/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.invoice;

import com.android.invoice.domain.VarietyMapper;
import com.android.invoice.domain.model.ADtlVarietyDto;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Scope;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
@Scope(value="session")
public class FetchAInvoiceItemFacts {
    private final DbConnection dbConnection;

    public List<ADtlVarietyDto> invoke(LoginDto login, @Nullable List<String> invoiceIdList) {
        String commaBoundStr = ConvertStr.commaBindStringsWithQuotes(invoiceIdList);
        String idSql = (String)ConvertStr.ifElse((boolean)ConvertStr.isNullOrEmpty((String)commaBoundStr), () -> "", () -> " f.id in (" + commaBoundStr + ") AND \n");
        String sql = " SELECT itf.ID AS serverId, f.Id AS invoiceId, fa.Id AS invoiceDtlId, \n itf.A_INDEX AS rowIndex, itf.Few AS amount, itf.A_Code AS articleCode, \n itf.PoshakIDF varietyIDF, itf.selPriceID \n FROM ItemFact itf \n INNER JOIN TmpFacture f ON " + idSql + " f.Id = CAST(itf.Fac_Code AS int)  INNER JOIN TmpFactArt fa ON fa.A_Index = itf.A_Index AND fa.IdFacture = f.Id \n WHERE itf.Fac_Type in ('5','6','7','8')  order by f.Id, fa.IdFacture, itf.id ";
        return this.dbConnection.getJdbcTemplate(login).query(sql, (RowMapper)new VarietyMapper());
    }

    public FetchAInvoiceItemFacts(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

